<?php
/**********
* Molting.php
* Permet de changer le thème (la skin) à la volée en version publique.
* Adaptation et Intégration dans adHoc Jean-Denis https://adhoc.71site.fr avril-juillet 2021 - révision mars 2023
* Licence: GNU-GPL V3
***********/
$skinspossibles = array('no_skin', 'ma_skin01', 'ma_skin02', 'ma_skin03', 'ma_skin04'); // liste des skins possibles sans limitation de nombre

// styles suplémentaires
$style0 = 'class="btn" style="float:none !important; margin-left:5%;"';
$style1 = 'class="btn" style="float:none !important; line-height:60px; margin-left:5%;"';
$style2 = 'style="font-weight:bold;font-size:140%;margin-left:5%;"';

// construction de la page
require_once("include/config.inc");

	// définition des variables de langue
	if (USER_LANG == 'fr') { // fr
	$meta['title'] = 'adHoc.71site.fr-Molting'; // titre
	$meta['description'] = 'Service de changement de themes'; // description
	$topmess = 'Skin au choix' ; // nom de la page
	$message1 = 'Thème (skin) actuel(le) :';
	$message2 = 'Choisissez un nouveau thème (skin) dans la liste, puis validez.';
	$message3 = 'Vous avez choisi le thème (skin) : ';
	$message4 = '<a '.$style1.' href="molting.php" target="_top"> Rafraîchir la page.</a>'; // message avec lien
	}
	elseif (USER_LANG == 'it') { // it
	$meta['title'] = 'adHoc.71site.fr-Molting'; // titre
	$meta['description'] = 'Servizio di cambio temi'; // description
	$topmess = 'Skin a scelta' ; // nom de la page
	$message1 = 'Tema (skin) attuale :';
	$message2 = 'Scegliete un nuovo tema (skin) dall\'elenco e convalidatelo.';
	$message3 = 'Hai scelto il tema (skin) : ';
	$message4 = '<a '.$style1.' href="molting.php" target="_top"> Aggiornare la pagina.</a>'; // message avec lien
	}
	elseif (USER_LANG == 'en') { // en
	$meta['title'] = 'adHoc.71site.fr-Molting'; // titre
	$meta['description'] = 'Theme change service'; // description
	$topmess = 'Skin with the choice' ; // nom de la page
	$message1 = 'Current theme (skin) :';
	$message2 = 'Choose a new theme (skin) from the list, then validate.';
	$message3 = 'You have chosen the theme (skin) : ';
	$message4 = '<a '.$style1.' href="molting.php" target="_top"> Refresh the page.</a>'; // message avec lien
	}

include_once(PATH_INC."hpage.inc");
htable($topmess, "100%");

// début contenu
$config = ReadCSVPairs('data/config/config.dbt'); // récupération données config.dbt
$skinactuelle = $config['theme']; // extraction du nom du thème actuel

// affichage du nom du thème actuel
echo '
<br /><p>'.$message1.'</p>
<p><span '.$style2.'>'.$skinactuelle.'</span></p><hr>';

// consigne de choix
echo '
<p>'.$message2.'</p><br />';

// liste déroulante
$nombre = count($skinspossibles); // compteur nombre de skins possibles
echo '
<form method="post">
<select name="skinspossibles" class="field">';
for ($i=0;$i<$nombre;$i++) {;
echo '<option value="'.$skinspossibles[$i].'"';
echo ">".$skinspossibles[$i]."</option>";
};
echo '</select>';

// bouton validation
echo '
<input '.$style0.' type="submit" name="submit" value="OK" />
</form>';

// test validation effectuée
if(isset($_POST['submit'])){
$selected_skin = $_POST['skinspossibles']; // skin sélectionnée
$config['theme'] = $selected_skin; // modification variable config avec skin sélectionnée
WriteCSVPairs('data/config/config.dbt', $config); // réenregistrement config
// message et lien rafraichissement de la page avec nouvelle skin
echo '
<hr><p>'.$message3.'<span '.$style2.'>'.$selected_skin.'</span>.<br />'.$message4.'</p>';
}

// fin contenu
btable();
include_once(PATH_INC."bpage.inc");
die();
?>