<?php
######################################################################################################
# Message Version 2.1 - [01/12/2025]                                                                 #
# message.php : Partie affichage du formulaire et saisie des réponses                                #
# Module pour AdHoc CMS   Développé par JeanDenis                                                    #
# Site Web : https://adhoc.71site.fr/                                                                #
# D'après modules réalisés par Penanders https://www.cmsadhoc.net/                                   #
# Pop-up admin d'après Django Blais http://www.trucsweb.com/tutoriels/css/css-modal/                 #
# Licence : GNU-GPL V3                                                                               #
######################################################################################################

// construction de la page
require_once("include/config.inc");

// Importation des variables
include ("modules/message/lang/".USER_LANG."_txt_public.php"); // inclusion variables + langues
$idlg = USER_LANG;
$cfg_message = ReadCSVPairs(PATH_DAT."message/config".DBEXT); // lecture fichier de configuration du module config.dtb
$cfg_message['connex'] == 'non' ? $connex = 0 : $connex = 1; // 0 : accessible au visiteur // ou 1 : accessible après connexion
$meta['title'] = $cfg_message['meta_tit_'.$idlg]; // Onglet de la page
$meta['description'] = $cfg_message['meta_des_'.$idlg]; // Description dans le code source

include_once(PATH_INC."hpage.inc");
htable($cfg_message['topmessage_'.$idlg], "100%");

// Vérification du statut de connexion !!Attention ne fonctionnera qu'avec le CMS adHoc!!
if (empty($_COOKIE['adHocUser'])) { // pas de connexion donc ne voit que ce qui est public
	$statconnex = 0 ;
	}
else { // connexion donc voit aussi l'affichage privé
	$statconnex = 1 ;
	}

// Affichage
if ($statconnex >= $connex) // vérification du statut avant affichage
{ // affichage public ou visiteur connecté

echo '<h4>'.$cfg_message['cons1_'.$idlg].'</h4>'; // consigne générale
echo '<hr>';

echo '<form action="message2.php" method="GET">'; // début formulaire public

// série 1
echo '<fieldset style="margin-top:0;">';
	// champ nom présent
echo '<p>'.$cfg_message['s1nom_'.$idlg].' : '.$ZobligA.'</p><input class="field" type="text" name="'.$cfg_message['s1nomc'].'" required>';

	// champ s1ch2 optionnel
if ($cfg_message['s1ch2p'] == 'oui')
	{if ($cfg_message['s1ch2r'] == 'oui')
		{echo '<p>'.$cfg_message['s1ch2_'.$idlg].' : '.$ZobligA.'</p><input class="field" type="text" name="'.$cfg_message['s1ch2c'].'" required>';}
		else
		{echo '<p>'.$cfg_message['s1ch2_'.$idlg].' : </p><input class="field" type="text" name="'.$cfg_message['s1ch2c'].'">';}
	}

	// champ s1ch3 optionnel
if ($cfg_message['s1ch3p'] == 'oui')
	{if ($cfg_message['s1ch3r'] == 'oui')
		{echo '<p>'.$cfg_message['s1ch3_'.$idlg].' : '.$ZobligA.'</p><input class="field" type="text" name="'.$cfg_message['s1ch3c'].'" required>';}
		else
		{echo '<p>'.$cfg_message['s1ch3_'.$idlg].' : </p><input class="field" type="text" name="'.$cfg_message['s1ch3c'].'">';}
	}

	// champ mail présent
echo '<p>'.$cfg_message['s1mail_'.$idlg].' : '.$ZobligA.'</p><input class="field" type="email" id="'.$cfg_message['s1mailc'].'" name="'.$cfg_message['s1mailc'].'" pattern=".+@.+\..+" placeholder="monemail@exemple.org" required>';

echo '<hr>';
echo '</fieldset>';
// fin série 1

if ($cfg_message['serie3'] == 'oui') { // série 3
echo '<h4>'.$cfg_message['cons3_'.$idlg].'</h4>'; // consigne série 3

// série 3 champ 1
$element = explode("|", $cfg_message['s3c1C_'.$idlg]);
echo '<p><label>'.$cfg_message['s3c1A_'.$idlg].' : </label></p>';
echo '<div><select name="'.$cfg_message['s3c1Ac'].'" class="field">';
for ($i=0;$i<count($element);$i++) {
echo '<option value="'.$element[$i].'">'.$element[$i].'</option>';
}
echo '</select></div>';
echo '<hr>';
} // fin série 3

// série 4
echo '<fieldset style="margin-top:0;">';
echo '<p><label for="'.$cfg_message['s4c1c'].'">'.$cfg_message['s4c1_'.$idlg].' : '.$ZobligA.'</label></p>';
echo '<textarea class="field" id="'.$cfg_message['s4c1c'].'" name="'.$cfg_message['s4c1c'].'" cols="40" rows="10" required></textarea>';
echo '</fieldset>';
echo '<p>'.$ZobligB.'</p>';
// fin série 4

// voir soumission avant enregistrement
echo '<div class="btn-group">
	<input class="btn block" type=submit value="'.$Zvoirsoum.'">
	</div>';

echo '</form>'; // fin formulaire public

echo '<hr>';

} else { // affichage privé
	echo $cfg_message['info_prive_'.$idlg];
	echo '<br>';
	echo '<hr><hr>';
	}

// Admin rapide et Référencement SVP ne pas supprimer
if(USER_LEVEL > 1) {
	echo '<span class="quick-links" style="background:transparent;"><a href="'.PATH.'admin/panel.php?pg=message"><img style="width:30px;height:30px;" src="'.PATH_LNK.'include/ico/settings.png" border="0" alt="admin" title="admin" /></a></span>';
}
echo '
<!-- "Module Message V2.1" - Jean-Denis https://adhoc.71site.fr décembre 2025 - Licence: GNU-GPL V3 -->
';

// fin contenu
btable();
include_once(PATH_INC."bpage.inc");
die();
?>
