<?php
/*********************************************************************************************************************
* links.php Version 2.1 - [08/04/2024]
* permet l'affichage de fiches descriptives de liens dans une seule page de type "accordéon" 
* Le script "pages accordéon" est issu de https://tympanus.net/codrops/2012/02/21/accordion-with-css3/ par Mary-Lou
* Pour cette version, les réglages d'effectuent uniquement par l'intermédiaire du module Links 2.0 intégré dans adHoc
* Adaptations et Intégration dans adHoc Jean-Denis https://adhoc.71site.fr (v 1.0 janv.2024) (v 2.0 fév.2024) (v 2.1 avr.2024)
* D'après modules réalisés par Penanders https://www.cmsadhoc.net/
* Il est nécessaire d'avoir créé, dans l'admin, chacunes des fiches de liens,...
* ...dans une ou plusieurs catégories dédiées, dans une ou plusieurs "boîtes menu" privées ou publiques
* Licence : GNU-GPL V3
**********************************************************************************************************************/

// Construction de la page
require_once("include/config.inc");

// Importation des variables
	$cfg_links = ReadCSVPairs(PATH_DAT."links/config".DBEXT); // lecture fichier de configuration du module config.dtb
	$numcat0 = $cfg_links['numcat0']; // numéro de la catégorie n°1 utilisée pour les fiches
	$numcat1 = $cfg_links['numcat1']; // numéro de la catégorie n°2 utilisée pour les fiches
	$numcat2 = $cfg_links['numcat2']; // numéro de la catégorie n°3 utilisée pour les fiches
	$numcat3 = $cfg_links['numcat3']; // numéro de la catégorie n°4 utilisée pour les fiches
	$numcat4 = $cfg_links['numcat4']; // numéro de la catégorie n°5 utilisée pour les fiches
	$numcat5 = $cfg_links['numcat5']; // numéro de la catégorie n°6 utilisée pour les fiches
	$numcat6 = $cfg_links['numcat6']; // numéro de la catégorie n°7 utilisée pour les fiches
	$numcat7 = $cfg_links['numcat7']; // numéro de la catégorie n°8 utilisée pour les fiches
	$numcat8 = $cfg_links['numcat8']; // numéro de la catégorie n°9 utilisée pour les fiches
	$numcat9 = $cfg_links['numcat9']; // numéro de la catégorie n°10 utilisée pour les fiches

	// liste des numéros (Id) des catégories dans l'ordre où vous souhaitez qu'elles s'affichent
	$numcategorie = array($numcat0, $numcat1, $numcat2, $numcat3, $numcat4, $numcat5, $numcat6, $numcat7, $numcat8, $numcat9);
	$typeaccordeon = $cfg_links['typeaccordeon']; // 'radio' ou 'checkbox' suivant le type d'accordéon souhaité

	// tous les volets de l'accordéon sont ouverts par défaut si oui et type checkbox // sinon fermés
	if ($cfg_links['tousouverts'] == 'oui' && $cfg_links['typeaccordeon'] == 'checkbox')
		{$tousouverts = 'checked="checked"';} else {$tousouverts = '';}

	$categorieouverte = $cfg_links['categorieouverte']; // Eventuellement un numéro de catégories à ouvrir par défaut

	if ($cfg_links['connex'] == 'non') {$connex = 0;} else {$connex = 1;} // 0 : accessible au visiteur // ou 1 : accessible après connexion

	$affdate = $cfg_links['affdate']; // affichage date
	if ($cfg_links['coum'] == 'crea') {$coum = 3;} else {$coum = 4;} // date création : 3 ou date dernière modification : 4
	$SouC = $cfg_links['SouC']; // 'S' : simple (sans heure) // 'C' : complète (date et heure)
	$cible = $cfg_links['cible']; // cible du lien


	// dont définition des variables de langue
	$idlg = USER_LANG;
	$meta['title'] = $cfg_links['meta_tit_'.$idlg]; // titre de la page (onglet) 
	$meta['description'] = $cfg_links['meta_des_'.$idlg]; // description (code source)
	$topmess = $cfg_links['topmessage_'.$idlg]; // nom de la page
	$prive = $cfg_links['info_prive_'.$idlg]; // avertissement si privé


// Vérification du statut de connexion !!Attention ne fonctionnera qu'avec le CMS adHoc!!
if (empty($_COOKIE['adHocUser'])) { // pas de connexion donc ne voit que ce qui est public
	$statconnex = 0 ;
	}
else { // connexion donc voit aussi l'affichage privé
	$statconnex = 1 ;
	}

// Fonctions
function statutboite($num) // fonction statutboite pour vérifier les droits d'affichage de cette boite
{
$nblignes = count(file('modules/pages/mod_lat_pages_'.$num.'.inc')); // nombre de lignes du fichier
$contenuboite = fopen( 'modules/pages/mod_lat_pages_'.$num.'.inc', 'r' ); // ouverture fichier et contenu
	for ($i=0; $i < $nblignes ; $i++) {
		$lignenouvelle = fgets($contenuboite);
		if (strncmp($lignenouvelle, '$pm_rights = ', 13) === 0) // vérification ligne droit
		{$droitboite = substr($lignenouvelle, 13, 1);} // récupération valeur droit
	}
fclose($contenuboite); // fermeture fichier
return $droitboite;
}

function affichagedateS($date) { // date simple
$pourdate = substr($date, 6, 2)."/".substr($date, 4, 2)."/".substr($date, 0, 4);
return $pourdate;
}

function affichagedateC($date) { // date complète (avec heure)
$pourdate = substr($date, 6, 2)."/".substr($date, 4, 2)."/".substr($date, 0, 4)." ".substr($date, 8, 2)."h".substr($date, 10, 2);
return $pourdate;
}

function nettoyagenom($nom) { // nettoyage éventuel du nom de catégorie ou de page
if ($nom[0] == '"' && substr($nom, -1) == '"') //test présence de guillemets au début ET à la fin
{$nom = substr($nom, 1, -1);} // ... les supprime le cas échéant
return $nom;
}

// construction de la page
include_once(PATH_INC."hpage.inc");
echo '
<!-- Début affichage "Module Links V2.1 // Service de Liens" -->
';
htable($topmess, "100%");

// Affichage
if ($statconnex >= $connex) // vérification du statut avant affichage
{ // affichage en partie publique ou visiteur connecté

// Style
echo '
<link charset="utf-8" href="skin/css/CSS_textes_accordeon-links.css" rel="stylesheet" />'; //fichier de style

// Elaboration contenu de la liste de toutes les catégories
$comptenbcategories = count(file('data/pages/list_'.$idlg.'.dbt')); // nombre de catégories dans la liste
$contenucategories = fopen( 'data/pages/list_'.$idlg.'.dbt', 'r' ); // ouverture fichier et contenu de cette liste

for ($i=0; $i < $comptenbcategories ; $i++) {
	$lignenouvelle = fgets($contenucategories);
	$elem = explode(";", $lignenouvelle);
		for ($j=0; $j < 6;$j++) {
		$chaquecategorie [$i][$j] = $elem[$j]; // création variables [catégorie][élément]
		}
}
fclose($contenucategories); // fermeture fichier

echo '
<section class="ac-container"><!-- début ac-container -->'; // début container accordéon

for ($k=0; $k < count($numcategorie) ; $k++) { // boucle pour le nombre max de catégories à afficher
	for ($i=0; $i < $comptenbcategories ; $i++) { // boucle pour chaque catégorie
		if ( $numcategorie [$k] == $chaquecategorie [$i][0]) { // vérification si la catégorie fait partie de la liste à afficher
			if ($statconnex >= statutboite($chaquecategorie [$i][1])) { // vérification du statut de la boite contenant la catégorie
				if ($categorieouverte == $numcategorie[$k] && $tousouverts == '') { // tests pour volet ouvert par défaut
					$ouvert = 'checked="checked"';}
					else {$ouvert = '';}
				if ($tousouverts == 'checked="checked"') {$ouvert = 'checked="checked"';} // tests pour volet ouvert par défaut

				// zone affichage nom catégorie
				echo '
				<div><!-- bloc ac-'.$numcategorie[$k].' -->
				<input '.$ouvert.' id="ac-'.$numcategorie[$k].'" name="accordion" type="'.$typeaccordeon.'" />
				<label for="ac-'.$numcategorie[$k].'">'.nettoyagenom($chaquecategorie [$i][3]).'</label>
				<article class="ac"><!-- début contenu volet accordéon -->';

				// Elaboration contenu de la catégorie en cours
				$comptenbrfiches = count(file('data/pages/pgidx_'.$numcategorie[$k].$idlg.'.dbt')); // nombre de fiches dans la catégorie
				$contenucatencours = fopen( 'data/pages/pgidx_'.$numcategorie[$k].$idlg.'.dbt', 'r' ); // ouverture fichier et contenu de cette catégorie

				for ($x=0; $x < $comptenbrfiches ; $x++) {
					$lignenouvelle = fgets($contenucatencours);
					$elem = explode(";", $lignenouvelle);
						for ($y=0; $y < 6;$y++) {
						$chaquefiche [$x][$y] = $elem[$y]; // création variables [fiche][élément] pour tous les items
						}
					}
				fclose($contenucatencours); // fermeture fichier

				for ($z=0; $z < $comptenbrfiches ; $z++) {
					if ($chaquefiche [$z][2] == 'i') {continue;} // test de la page concernée (saute l'hypothèse si page inactive)
					include ('data/pages/page_'.$chaquefiche [$z][0].$idlg.'.inc'); // inclusion fichier page concernée
					$name = nettoyagenom($chaquefiche [$z][1]) ; // nom de la fiche -page-
					$comment = $ftxt; // commentaire pour ce lien : récupération variable contenu fiche -page-
					$verslien = $fmdes; // lien absolu qui aura été placé en Meta Description de la fiche -page-

				// zone affichage contenu fiche - page concernée : lien, nom, éventuellement date, commentaire 
					if ($affdate == 'oui') { // test date
						if ($SouC == 'S')
						{$ladate = affichagedateS($chaquefiche [$z][$coum]);} // date simple
						else
						{$ladate = affichagedateC($chaquefiche [$z][$coum]);} // date complète
					$presencedate = '<span style="float:right;padding-right:40px;font-size:70%;"><i>'.$ladate.'</i></span>';}
					else { $presencedate = '';} // sans date

					echo '
					<h4><a href="'.$verslien.'" target="'.$cible.'"></a>'.$name.$presencedate.'</h4>
					<div class="comment">'.$comment.'</div>
					<div class="sep"></div><!-- ligne séparation -->';
				}
				
				echo '
				</article><!-- fin contenu volet accordéon -->
				</div><!-- fin bloc ac-'.$numcategorie[$k].' -->';
			} // fin test statut boite
		} // fin test catégorie
	} // fin boucle $i
} // fin boucle $k

echo '
</section><!-- fin ac-container -->'; // fin container accordéon

} else { // privé
	echo $prive;
	echo '<br>';
	echo '<hr><hr>';
	}

// Admin rapide et Référencement SVP ne pas supprimer
if(USER_LEVEL > 1) {
	echo '<span class="quick-links" style="background:transparent;"><a href="'.PATH.'admin/panel.php?pg=links"><img style="width:30px;height:30px;" src="'.PATH_LNK.'include/ico/settings.png" border="0" alt="admin" title="admin" /></a></span>';
}
echo '
<!-- "Module Links V2.1 // Service de Liens" - Jean-Denis https://adhoc.71site.fr avril 2024 - Licence: GNU-GPL V3 -->
';

// fin contenu
btable();
include_once(PATH_INC."bpage.inc");
die();
?>

