<?php
########################################################################################
# Hasard Version 3.3 - [22/07/2024]                                                    #
# Module pour AdHoc CMS   Développé par JeanDenis (compatible adHoc 0.70)              #
# Site Web : https://adhoc.71site.fr/                                                  #
# D'après modules réalisés par Penanders https://www.cmsadhoc.net/                     #
# Accompagné nécessairement d'un fork du script modules/boxes/lateral.inc du CMS adHoc #
# Licence : GNU-GPL V3                                                                 #
########################################################################################

// Fonctions
$sep = "-";
function has_nettoyage($chaine) {
	$cherche = array(
		"À", "Á", "Â", "Ã", "Ä", "Å", "Æ", "Ç", "È", "É", "Ê", "Ë", "Ì", "Í", "Î", "Ï",
		"Ð", "Ñ", "Ò", "Ó", "Ô", "Õ", "Ö", "Ø", "Ù", "Ú", "Û", "Ü", "Œ", " ", "'", ".",
		"à", "á", "â", "ã", "ä", "å", "æ", "ç", "è", "é", "ê", "ë", "ì", "í", "î", "ï",
		"ð", "ñ", "ò", "ó", "ô", "õ", "ö", "ø", "ù", "ú", "û", "ü", "ý", "œ", "&"
	);
	$remplace = array(
		"a", "a", "a", "a", "a", "a", "ae", "c", "e", "e", "e", "e", "i", "i", "i", "i",
		"o", "n", "o", "o", "o", "o", "o", "o", "u", "u", "u", "u", "oe", "-", "-", "_",
		"a", "a", "a", "a", "a", "a", "ae", "c", "e", "e", "e", "e", "i", "i", "i", "i",
		"o", "n", "o", "o", "o", "o", "o", "o", "u", "u", "u", "u", "y", "oe", "-and-"
	);
	$chaine = strtolower(str_replace($cherche, $remplace, strip_tags($chaine)));
	$chaine = preg_replace('/[^[:alnum:]|_|-]+/','',$chaine);
	return mb_convert_encoding(preg_replace('/-+/', '-', $chaine),'ASCII');
}

function has_datepourcomparaison($date) {
	$nouvdate = substr($date, 0, -8).$sep.substr($date, 4, -6).$sep.substr($date, 6, -4);
	return $nouvdate;
}

function has_calculintervaledate($datejour, $datecible) {
	$dj = date_create(has_datepourcomparaison($datejour));
	$dc = date_create(has_datepourcomparaison($datecible));
	$intervale = date_diff($dj, $dc);
	return $intervale->format('%a');
}

function has_droit($fichier) { // mise en place pour adHoc 0.70
	$debut = '$pm_rights = ';
	$extrait = file_get_contents($fichier); // récupère tout le code source du fichier
	$extrait = strstr($extrait, $debut); // Coupe ce qui précède $debut
	$droit = substr($extrait, 13, 1); // Extrait la valeur du droit du menu
	return $droit;
}

// Elaboration des variables array $hasdbwork[] contenant tous les éléments d'une page :
// "numéro" "nom de la page "nom de sa catégorie" "date création" "date modification" "active ou inactive" "durée affichage newup"
$idlg = USER_LANG;
$pg_cmenu = true; // adHoc 0.70

if (defined('PGBX_INC')) { // test pour affichage page index ou default

	for ($i=0; $i < count(glob(PGBX_INC.'*.inc')); $i++) {
		if (file_exists(PATH."modules/pages/mod_lat_pages_".$i.".inc")) {
			$haspboxes[$i] = PGBX_INC.'mod_lat_pages_'.$i.'.inc';
			$haspbxrights[$i] = has_droit($haspboxes[$i]); // droits des menus
		}
	}

} else { // alternative test pour affichage page index ou default

	for ($i=0; $i < count(glob('modules/pages/*.inc')); $i++) {
		if (file_exists(PATH."modules/pages/mod_lat_pages_".$i.".inc")) {
			$haspboxes[$i] = 'modules/pages/mod_lat_pages_'.$i.'.inc';
			$haspbxrights[$i] = has_droit($haspboxes[$i]); // droits des menus
		}
	}

}

unset($pg_cmenu); // adHoc 0.70

if (defined('PGBX_DAT')) { // test pour affichage page index ou default

	$hascountctlist = count(file(PGBX_DAT.'list_'.$idlg.'.dbt')); // nombre de catégories
	$hascontenu = fopen( PGBX_DAT.'list_'.$idlg.'.dbt', 'r' );

} else { // alternative test pour affichage page index ou default

	$hascountctlist = count(file('data/pages/list_'.$idlg.'.dbt')); // nombre de catégories
	$hascontenu = fopen( 'data/pages/list_'.$idlg.'.dbt', 'r' );

}

	for ($i=0; $i < $hascountctlist ; $i++) {
	$lignecat = fgets($hascontenu);
	$elem = explode(";", $lignecat);
		for ($j=0; $j < 7;$j++) {
			$hasctlist [$i][$j] = $elem[$j]; // création variables [catégorie][élément]
		}
	}
	fclose($hascontenu);

for ($i=0; $i < $hascountctlist; $i++ ) { // boucle pour chaque catégorie
	if (in_array($hasctlist[$i][0], $catinterdite)) {continue;} // test de l'Id de la catégorie (saute l'hypothèse si catégorie interdite)
	if (USER_LEVEL >= $haspbxrights[$hasctlist[$i][1]]) { // droits d'affichage
		$hasdbwork[] = array("*", $hasctlist[$i][3]);

		if (defined('PGBX_IDX')) { // test pour affichage page index ou default

		$hascountpglist = count(file(PGBX_IDX.$hasctlist[$i][0].$idlg.'.dbt')); // nombre de pages dans catégorie
		$hascontenucat = fopen( PGBX_IDX.$hasctlist[$i][0].$idlg.'.dbt', 'r' );

		} else { // alternative test pour affichage page index ou default

		$hascountpglist = count(file('data/pages/pgidx_'.$hasctlist[$i][0].$idlg.'.dbt')); // nombre de pages dans catégorie
		$hascontenucat = fopen( 'data/pages/pgidx_'.$hasctlist[$i][0].$idlg.'.dbt', 'r' );

		}

		for ($k=0; $k < $hascountpglist ; $k++) {
			$lignepage = fgets($hascontenucat);
			$elemt = explode(";", $lignepage);
				for ($j=0; $j < 6;$j++) {
					$haspglist [$k][$j] = $elemt[$j]; // création variables [page][élément]
				}

			//  contenu $hasdbwork[] : "numéro" "nom de la page "nom de sa catégorie" "date création" "date modification" "active ou inactive" "durée affichage newup"
			$hasdbwork[] = array($haspglist[$k][0], $haspglist[$k][1], $hasctlist[$i][3], $haspglist[$k][3], $haspglist[$k][4], $haspglist[$k][2], $haspglist[$k][5]);

		}
		fclose($hascontenucat);
		//$pgtotitems += $hascountpglist; 
	}
}

$count = count($hasdbwork); // nombre d'articles/pages

// si affichage info nouveauté ou maj prévu : choix texte ou image
if($hasinfonewup == 'oui') {
	if ($hasnewup == "texte") {
		$pg_img_upd = '<span class="label-upd" '.$hasstylesupupd.'>'.$msg_pub['updated'].'</span>';
		$pg_img_new = '<span class="label-new" '.$hasstylesupnew.'>'.$msg_pub['new'].'</span>';
	} else {
		$pg_img_upd = '<img class="img-upd" '.$hasstylesupupd.'src="'.PATH_LNK.'modules/pages/img/'.$hasimageUpdate.'" alt="up" title="Updated"/>';
		$pg_img_new = '<img class="img-new" '.$hasstylesupnew.'src="'.PATH_LNK.'modules/pages/img/'.$hasimageNew.'" alt="new" title="New"/>';
	}
}

// Affichage
echo "<!-- début affichage hasard -->\n";
echo "<!-- Module Hasard v3.3 JeanDenis https://adhoc.71site.fr Licence GNU-GPL V3 -->\n";
if ($hasafftitre == 'oui') { // affichage ou non du titre
	echo "<".$titrehn." ".$hasstylesup0.">".$hasmessage."</".$titrehn.">\n";
} else { echo "<br />\n"; }

do {$has = rand (0,$count-1);}
while (($hasdbwork[$has][0] == "*") || (in_array($hasdbwork[$has][0], $haspagesexclues)) || $hasdbwork[$has][5] == 'i'); // empêche l'affichage de ces hypothèses

if ($hasaffcat == 'oui') { // affichage ou non du nom de catégorie + has_nettoyage guillemets
$taillecat = strlen($hasdbwork[$has][2]);
if (substr($hasdbwork[$has][2], 0, -($taillecat-1)) == '"' && substr($hasdbwork[$has][2], -1, 1) == '"') 
	{$nomcat = substr($hasdbwork[$has][2], 1, -1);}
else {$nomcat = $hasdbwork[$has][2];}

echo "<".$catarthn." ".$hasstylesup1."><span ".$hasstylesup2.">".$nomcat."</span>\n"; // affichage du nom de catégorie
} else { echo "<".$arthn." ".$hasstylesup1.">"; } // pas de nom de catégorie

if ($haslignecat_art != 'oui' && $hasaffcat == 'oui') echo "</".$catarthn.">\n<".$arthn." ".$hasstylesup4.">"; //  cat. art. changement ligne

$tailleart = strlen($hasdbwork[$has][1]); // affichage nom article + der_nettoyage guillemets
if (substr($hasdbwork[$has][1], 0, -($tailleart-1)) == '"' && substr($hasdbwork[$has][1], -1, 1) == '"') 
	{$nomart = substr($hasdbwork[$has][1], 1, -1);}
else {$nomart = $hasdbwork[$has][1];}


if (defined('PGBX_IDX')) { // test pour affichage page index ou default
echo "<span ".$hasstylesup3."><a href=\"".$hasdbwork[$has][0].has_nettoyage($sep.$hasdbwork[$has][2].$sep.$hasdbwork[$has][1].$sep).$idlg.".php"."\" ".$hasciblelien." >".$nomart."</a></span>";
} else { // alternative test pour affichage page index ou default
echo "<span ".$hasstylesup3."><a href=\"pages/".$hasdbwork[$has][0].has_nettoyage($sep.$hasdbwork[$has][2].$sep.$hasdbwork[$has][1].$sep).$idlg.".php"."\" ".$hasciblelien." >".$nomart."</a></span>";
}

// si affichage info nouveauté ou maj prévu
if($hasinfonewup == 'oui') {
	$newup = '';
	if (has_calculintervaledate(date("YmdHi"), $hasdbwork[$has][3]) - $hasdbwork[$has][6] <= 0 && has_datepourcomparaison($hasdbwork[$has][3]) == has_datepourcomparaison($hasdbwork[$has][4])) { // comparaison date création
		$newup = $pg_img_new;
	}
	elseif (has_calculintervaledate(date("YmdHi"), $hasdbwork[$has][4]) - $hasdbwork[$has][6] <= 0) { // comparaison date modification
		$newup = $pg_img_upd;
	}
	echo $newup;
}

if ($hasaffcat == 'oui' && $haslignecat_art == 'oui') {echo "</".$catarthn.">\n";} // cat art même ligne balise fermeture
else { echo "</".$arthn.">\n";} // cat art lignes différentes ou pas de nom de catégorie

echo "<!-- fin affichage hasard -->\n";
// Admin rapide
if(USER_LEVEL > 1) {
	echo '<span class="quick-links" style="background:transparent;"><a href="'.PATH.'admin/panel.php?pg=hasard"><img style="width:30px;height:30px;" src="'.PATH_LNK.'include/ico/settings.png" border="0" alt="admin" title="admin" /></a></span>';
}
?>


