<?php
/**********
* blog.php version 2.2 22/07/2024
* Permet l'affichage sur une page des X dernières nouvelles - billets, courts messages de type blog -
* Il est nécessaire d'avoir créé ces nouvelles dans une catégorie dédiée.
* Pour cette version, les réglages d'effectuent uniquement par l'intermédiaire du module Blog 2.0 intégré dans adHoc
* Adaptation et Intégration dans adHoc Jean-Denis https://adhoc.71site.fr décembre 2023 - janvier-avril 2024 // correction mineure compatible adHoc 0.70 juillet 2024
* Licence: GNU-GPL V3
***********/


// Construction de la page
require_once("include/config.inc");

// Fonctions
	function affichagedateS($date) { // date simple
	$pourdate = substr($date, 6, 2)."/".substr($date, 4, 2)."/".substr($date, 0, 4);
	return $pourdate;
	}

	function affichagedateC($date) { // date complète (avec heure)
	$pourdate = substr($date, 6, 2)."/".substr($date, 4, 2)."/".substr($date, 0, 4)." ".substr($date, 8, 2)."h".substr($date, 10, 2);
	return $pourdate;
	}

	function nettoyagenom($nom) { // nettoyage éventuel d'un titre
	if ($nom[0] == '"' && substr($nom, -1) == '"') //test présence de guillemets au début ET à la fin
	{$nom = substr($nom, 1, -1);} // ... les supprime le cas échéant
	return $nom;
	}

// Importation des variables
	$cfg_blog = ReadCSVPairs(PATH_DAT."blog/config".DBEXT); // lecture fichier de configuration du module config.dtb
	$numcat = $cfg_blog['numcat']; // numéro de la catégorie utilisée pour les billets
	$nbnews = $cfg_blog['nbnews']; // nombre de billets affichés // Si 0 (zéro) : affiche tous les billets
	$ordrechrono = $cfg_blog['ordrechrono']; // rangement chono : 'non' (dernier de liste = premier affiché) // 'oui' (premier de liste = premier affiché)
	if ($cfg_blog['connex'] == 'non') {$connex = 0;} else {$connex = 1;} // 0 : accessible au visiteur // ou 1 : accessible après connexion
	$affauteur = $cfg_blog['affauteur']; // affichage auteur
	$affdate = $cfg_blog['affdate']; // affichage date
	if ($cfg_blog['coum'] == 'crea') {$coum = 3;} else {$coum = 4;} // date création : 3 ou date dernière modification : 4
	$SouC = $cfg_blog['SouC']; // 'S' : simple (sans heure) // 'C' : complète (date et heure)
	$cible = $cfg_blog['cible']; // cible du lien vers le billet
	$overflow = $cfg_blog['overflow']; // mise en place ascenseur vertical : 'oui' ou 'non'
	$maxheight = $cfg_blog['maxheight']; // hauteur en pixels avant ascenseur si mis en place

	// dont définition des variables de langue
	$idlg = USER_LANG;
	$meta['title'] = $cfg_blog['meta_tit_'.$idlg]; // titre de la page (onglet) 
	$meta['description'] = $cfg_blog['meta_des_'.$idlg]; // description (code source)
	$topmess0 = str_replace(' | ', ' ', $cfg_blog['topmessage_'.$idlg]); // nom de la page si tous les billets sont affichés
	$topmessX = str_replace('|', $nbnews, $cfg_blog['topmessage_'.$idlg]); // nom de la page dynamique avec le nombre de billets affichés
	$prive = $cfg_blog['info_prive_'.$idlg]; // avertissement si privé


// Vérification du statut de connexion !!Attention ne fonctionnera qu'avec le CMS adHoc!!
if (empty($_COOKIE['adHocUser'])) { // pas de connexion donc ne voit que ce qui est public
	$statconnex = 0 ;
	}
else { // connexion donc voit aussi l'affichage privé
	$statconnex = 1 ;
	}

// Elaboration contenu de la catégorie de nouvelles
$comptenbnouvelles = count(file('data/pages/pgidx_'.$numcat.$idlg.'.dbt')); // nombre de nouvelles dans la catégorie
$contenucatnouvelles = fopen( 'data/pages/pgidx_'.$numcat.$idlg.'.dbt', 'r' ); // ouverture fichier et contenu de cette catégorie

for ($i=0; $i < $comptenbnouvelles ; $i++) {
	$lignenouvelle = fgets($contenucatnouvelles);
	$elem = explode(";", $lignenouvelle);
		for ($j=0; $j < 6;$j++) {
		$chaquenouvelle [$i][$j] = $elem[$j]; // création variables [nouvelle][élément] pour toutes les nouvelles
		}
	}
fclose($contenucatnouvelles); // fermeture fichier

	// suivi du test d'activité/inactivité de chaque nouvelle
$inactive = 0; // initialisation variable
for ($i=0; $i < $comptenbnouvelles ; $i++) {
	if ($chaquenouvelle [$i][2] == 'i') {$inactive = $inactive+1; continue;} // incrémente la variable et saute cette hypothèse
	for ($j=0; $j < 6;$j++) {
	$nouvelleactive [$i-$inactive][$j] = $chaquenouvelle [$i][$j]; // variables [nouvelle][élément] pour les nouvelles actives seulement
	}
}
$comptenbnouvelles = $comptenbnouvelles-$inactive; // Ajustement du nombre de nouvelles actives

// Ajustement de la demande d'affichage et du titre de la page
if ($nbnews > $comptenbnouvelles) {$nbnews = $comptenbnouvelles;} // test si demande affichage plus grand que nombre de nouvelles
if ($nbnews == 0 || $nbnews == $comptenbnouvelles) {$topmess = $topmess0; $nbnews = $comptenbnouvelles;} else {$topmess = $topmessX;} // choix du titre

// Début construction de la page
include_once(PATH_INC."hpage.inc");
echo '
<!-- Début affichage "Module service Nouvelles-Blog V2.1" -->
';
htable($topmess, "100%");

// Affichage
if ($statconnex >= $connex) // vérification du statut avant affichage
{ // affichage public ou visiteur connecté
if ($overflow == 'oui') {echo '<div style="max-height:'.$maxheight.'px;padding-right:10px;overflow:auto">';} // test overflow
	for ($k=0; $k < $nbnews ; $k++) {
		if ($ordrechrono == 'non') {$var = $comptenbnouvelles-$k-1;} else {$var = $k;}
		include ('data/pages/page_'.$nouvelleactive [$var][0].$idlg.'.inc'); // inclusion fichier page concernée

		$titrenouvelle = nettoyagenom($nouvelleactive [$var][1]); // titre nouvelle

		echo '<h3><a href="pages/pages.php?pg='.$nouvelleactive [$var][0].'&lg='.$idlg.'" target="'.$cible.'">'.$titrenouvelle.'</a>'; // affichage titre/lien page
		if ($affdate == 'oui') { // test date
			if ($SouC == 'S')
				{$ladate = affichagedateS($nouvelleactive [$var][$coum]);} // date simple
			else
				{$ladate = affichagedateC($nouvelleactive [$var][$coum]);} // date complète
		echo '<span style="float:right;padding-right:40px;font-size:70%;"><i>'.$ladate.'</i></span></h3>'; // affichage date 
		} else { echo '</h3>'; }

		echo $ftxt; // affichage article
		echo '<br>';

		if ($affauteur == 'oui') { //test auteur
		echo '<p style="text-align:right;padding-right:40px;"><i>'.$fauth.'</i></p>'; // affichage auteur
		}
		echo '<br>';
		echo '<hr><hr>';
	}
} else { //privé
	echo $prive;
	echo '<br>';
	echo '<hr><hr>';
	}
if ($overflow == 'oui') {echo '</div><!-- fin overflow -->';} // fin overflow si mis en place

// Admin rapide et Référencement SVP ne pas supprimer
if(USER_LEVEL > 1) {
	echo '<span class="quick-links" style="background:transparent;"><a href="'.PATH.'admin/panel.php?pg=blog"><img style="width:30px;height:30px;" src="'.PATH_LNK.'include/ico/settings.png" border="0" alt="admin" title="admin" /></a></span>';
}
echo '
<!-- "Module service Nouvelles-Blog V2.1" - Jean-Denis https://adhoc.71site.fr avril 2024 - Licence: GNU-GPL V3 -->
';

// Fin contenu de la page
btable();
include_once(PATH_INC."bpage.inc");
die();
?>
