<!doctype html>
<!--
	* Script principal trouvé ici : https://codes-sources.commentcamarche.net/source/42671-calendrier-simple-facilement-modifiable-affichage-complet
			Auteur : Greenzest
	* Adaptations graphiques + traitement dimanches et jours fériés (2018 - 2020)
	* Création d'un service de liens (éventuellement différenciés si le visiteur est connecté -pour adHoc-) 
		s'affichant dans les cellules du calendrier et renvoyant vers des pages spécifiques (avril 2023)
			par JeanDenis https://www.71site.fr ; https://adhoc.71site.fr (pour le CMS adHoc https://www.cmsadhoc.net )
	Licence: GNU-GPL V3
 -->
<html lang="fr">
<head>
	<meta content="text/html; charset=utf-8" http-equiv="content-type">
	<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Calendrier</title>

<?php
// récupération des éventuelles variables passées, on donne soit année; mois; année+mois
if(!isset($_GET['mois'])) $num_mois = date("n"); else $num_mois = $_GET['mois'];
if(!isset($_GET['annee'])) $num_an = date("Y"); else $num_an = $_GET['annee'];

// pour ne pas s'embêter à les calculer à l'affichage des flèches de navigation...
if($num_mois < 1) { $num_mois = 12; $num_an = $num_an - 1; }
elseif($num_mois > 12) { $num_mois = 1; $num_an = $num_an + 1; }

// affectation du début des variables pour nommer les fichiers contenant les liens ( année+mois )
$an = $num_an;
$mois = $num_mois;
if ($mois == 1) { $moisAV = 12 ; $moisAP = 2 ; $anAV = $an-1 ; $anAP = $an ; } ;
if ($mois == 12) { $moisAP = 1 ; $moisAV = 11 ;$anAP = $an+1 ; $anAV = $an ; } ;
if ($mois > 1 && $mois < 12) { $moisAV = $mois-1 ; $moisAP = $mois+1 ; $anAV = $an ; $anAP = $an ; } ;
for($k=1;$k<10;$k++) { 
	if ($mois == $k) { $mois = "0".$mois; }
	if ($moisAV == $k) { $moisAV = "0".$moisAV; }
	if ($moisAP == $k) { $moisAP = "0".$moisAP; }
	} ;
$nomCR = $an.$mois ; // num an+mois courant
$nomAV = $anAV.$moisAV ; // num an+mois avant 
$nomAP = $anAP.$moisAP ; // num an+mois après

// nombre de jours dans le mois et numéro du premier jour du mois courant
$int_nbj = date("t", mktime(0,0,0,$num_mois,1,$num_an));
$int_premj = date("w",mktime(0,0,0,$num_mois,1,$num_an));

// tableau des jours, tableau des mois...
$tab_jours = array("","Lu","Ma","Me","Je","Ve","Sa","Di");
$tab_mois = array("","Janvier","Février","Mars","Avril","Mai","Juin","Juillet","Août","Septembre","Octobre","Novembre","Décembre");

$int_nbjAV = date("t", mktime(0,0,0,($num_mois-1<1)?12:$num_mois-1,1,$num_an)); // nb de jours du mois d'avant
$int_nbjAP = date("t", mktime(0,0,0,($num_mois+1>12)?1:$num_mois+1,1,$num_an)); // nb de jours du mois d'après

// on affiche les jours du mois et aussi les jours des mois avant/après, on indique ceux-ci par une * et à l'affichage on modifiera leur apparence
// on prépare aussi le tableau des noms des fichiers de liens
$tab_cal = array(array(),array(),array(),array(),array(),array()); // tab_cal[Semaine][Jour de la semaine]
$tab_fich = array(array(),array(),array(),array(),array(),array()); // tab_fich même modèle ci-dessus : stockage noms de fichiers de liens
$int_premj = ($int_premj == 0)?7:$int_premj; // initialisation des variables des boucles
$t = 1; $p = ""; $m = 1 ; // initialisation des variables des boucles
for($i=0;$i<6;$i++) {
	for($j=0;$j<7;$j++) {
		if($j+1 == $int_premj && $t == 1) { $tab_cal[$i][$j] = $t; $tab_fich[$i][$j] = $nomCR."0".$t ;$t++; } // on stocke le premier jour du mois

		elseif($t > 1 && $t <= $int_nbj) { // on incrémente à chaque fois dans le mois courant ($m==1) ou suivant ($m==2)
			if ($m == 1) // mois courant
			{ $tab_cal[$i][$j] = $p.$t; if ($t<10) {$tab_fich[$i][$j] = $nomCR."0".$t;} else {$tab_fich[$i][$j] = $nomCR.$t;}; $t++;}
			else // mois suivant
			{ $tab_cal[$i][$j] = $p.$t; if ($t<10) {$tab_fich[$i][$j] = $nomAP."0".$t;} else {$tab_fich[$i][$j] = $nomAP.$t;}; $t++;}
			} // on incrémente à chaque fois dans le mois courant ($m==1) ou suivant ($m==2)

		elseif($t > $int_nbj) { // on met le premier jour du mois suivant et on passe à $m==2
			$p="*"; $tab_cal[$i][$j] = $p."1"; $tab_fich[$i][$j] = $nomAP."01"; $t = 2; $m = 2;
			} // on met le premier jour du mois suivant et on passe à $m==2

		elseif($t == 1) { // on met ceux du mois précédent
			$tab_cal[$i][$j] = "*".($int_nbjAV-($int_premj-($j+1))+1);
			$tab_fich[$i][$j] = $nomAV.($int_nbjAV-($int_premj-($j+1))+1);
			} // on met ceux du mois précédent
	}
}

// routines jours fériés
for($i=0;$i<6;$i++) { // initialisation tableau jours fériés à 0 puis calcul jours fériés mobiles
	for($j=0;$j<7;$j++) {
		$tab_ferie[$i][$j] = 0;
	}
}
$paquem = date("n", easter_date($num_an)+86400); // mois et jour lundi de paques >> 2037
$paquej = date("j", easter_date($num_an)+86400);
$ascensionm = date("n", easter_date($num_an)+86400*39); // mois et jour ascension >> 2037
$ascensionj = date("j", easter_date($num_an)+86400*39);
$pentecotem = date("n", easter_date($num_an)+86400*50); // mois et jour lundi de pentecote >> 2037
$pentecotej = date("j", easter_date($num_an)+86400*50); 

for($i=0;$i<6;$i++) { // enregistrement jours fériés à 1 dans le tableau : jours fixes, puis jours mobiles
	for($j=0;$j<7;$j++) { //  !! attention, seuls les jours fériés du mois courant sont pris en compte !!
		switch ($num_mois) 
		{
			case 1 : // janvier
				if ($tab_cal[$i][$j] == 1) {$tab_ferie[$i][$j] = 1;}
			break;
			case 5 : // mai
				if ($tab_cal[$i][$j] == 1 || $tab_cal[$i][$j] == 8) {$tab_ferie[$i][$j] = 1;}
			break;
			case 7 : // juillet
				if ($tab_cal[$i][$j] == 14) {$tab_ferie[$i][$j] = 1;}
			break;
			case 8 : // août
				if ($tab_cal[$i][$j] == 15) {$tab_ferie[$i][$j] = 1;}
			break;
			case 11 : // novembre
				if ($tab_cal[$i][$j] == 1 || $tab_cal[$i][$j] == 11) {$tab_ferie[$i][$j] = 1;}
			break;
			case 12 : // décembre
				if ($tab_cal[$i][$j] == 25) {$tab_ferie[$i][$j] = 1;}
			break;
		}
		if ($num_mois == $paquem && $tab_cal[$i][$j] == $paquej ) {$tab_ferie[$i][$j] = 1;} // lundi de paques
		if ($num_mois == $ascensionm && $tab_cal[$i][$j] == $ascensionj ) {$tab_ferie[$i][$j] = 1;} // ascension
		if ($num_mois == $pentecotem && $tab_cal[$i][$j] == $pentecotej ) {$tab_ferie[$i][$j] = 1;} // lundi de pentecote
	}
}

// Vérification du statut de connexion !!Attention ne fonctionnera qu'avec le CMS adHoc!!
if (empty($_COOKIE['adHocUser'])) { // pas de connexion membre donc affichage public
	$statconnex = 0 ;
	}
else { // connexion en tant que membre donc affichage privé
	$statconnex = 1 ;
	}
?>

<!--
	tous les réglages dans le style sont aux unités vw
	(relatives au viewport, essentielles pour mettre en place un design responsive)
-->

<style>
body {
	font: 6vw Arial, Helvetica, sans-serif;
	color:#FFFFFF;
	margin: 0;
	padding: 0;	
	background:rgba(0, 0, 0, .3); /* couleur et transparence du fond */
}
table { border-collapse:collapse; }
tr { text-align:center; }
td { text-align:center; }

a, a:visited { /* liens mois courant */
	text-decoration: underline; /* ou none, ou... */
	color: #FF9900;
}
a:hover { /* liens mois courant */
	color: #FFFF00;
}
a span, a span:visited { /* liens mois précédent ou suivant */
	text-decoration: underline #FF9900; /* ou none, ou... */
	color: #C0C0C0;
}
a span:hover { /* liens mois précédent ou suivant */
	text-decoration: underline #FFFF00; /* ou none, ou... */
	color: #FFFF00;
}
</style>

<?php
// affectation variables et sources !! à modifier suivant votre configuration et vos souhaits, respectez bien les syntaxes !!
// pour symboliser le jour "j" un cadre (cadre.png) est affiché, supprimez-le, changez-le, changez sa source à votre convenance...
$dossier = 'files/calendrier/' ; // répertoire dans lequel seront stockés les fichiers de liens
$ciblelien = '" target="_top"'; // ou _blank pour ouvrir les liens dans une autre fenêtre, ou...
$imagegauche = 'src="../images/gauche.png" style="border-width: 0vw; border-style: solid; width: 6vw; height: 4vw;"'; // source flèche gauche
$imagedroite = 'src="../images/droite.png" style="border-width: 0vw; border-style: solid; width: 6vw; height: 4vw;"'; // source flèche droite
$stylebandeaumois = 'style="font-size:7.5vw;"';
$stylebandeauannee = 'style="font-size:7.5vw;"';
$stylebandeaujours = 'style="background:rgba(255, 255, 255, .7);color:#000000;font-size:6vw;"';
$stylecellulesnom = 'style="padding:2vw 3vw;"';
$stylebandeauxquantiemes = 'style="font-size:6vw;"';
$styledimanchejourj = ' style="background:#A7272E;background-image: url(../images/cadre.png);background-size: 100% 100%; "'; // source du cadre
$styledimanche = ' style="background:#A7272E; "';
$styleferiejourj = ' style="background:#A7272E;border-radius:2.2vw;background-image: url(../images/cadre.png);background-size: 100% 100%; "'; // source du cadre
$styleferie = ' style="background:#A7272E; "';
$styleautrejourj = ' style="background-image: url(../images/cadre.png);background-size: 100% 100%; "'; // source du cadre
$policejourmoisAVetAP = ' color="#909090"';
$policedimanchemoisAVetAP = ' color="#747474"';
?>

</head>
<body>
<table align="center">
	<tr <?php echo $stylebandeaumois; ?>><td colspan="7"><a href="calendrier.php?mois=<?php echo $num_mois-1; ?>&amp;annee=<?php echo $num_an; ?>"><img alt="gauche.png" <?php echo $imagegauche; ?> /></a>&nbsp;&nbsp;<?php echo $tab_mois[$num_mois];  ?>&nbsp;&nbsp;<a href="calendrier.php?mois=<?php echo $num_mois+1; ?>&amp;annee=<?php echo $num_an; ?>"><img alt="droite.png" <?php echo $imagedroite; ?> /></a></td></tr>
	<tr <?php echo $stylebandeauannee ?>><td colspan="7"><a href="calendrier.php?mois=<?php echo $num_mois; ?>&amp;annee=<?php echo $num_an-1; ?>"><img alt="gauche.png" <?php echo $imagegauche; ?> /></a>&nbsp;&nbsp;<?php echo $num_an;  ?>&nbsp;&nbsp;<a href="calendrier.php?mois=<?php echo $num_mois; ?>&amp;annee=<?php echo $num_an+1; ?>"><img alt="droite.png" <?php echo $imagedroite; ?> /></a></td></tr>
<?php
	echo'<tr '.$stylebandeaujours.'>';
	for($i = 1; $i <= 7; $i++){
		echo('<td '.$stylecellulesnom.'><b>'.$tab_jours[$i].'</b></td>');
	}
	echo'</tr>';

	for($i=0;$i<6;$i++) {
		echo '<tr '.$stylebandeauxquantiemes.'>';
		for($j=0;$j<7;$j++) {
		// si le fichier existe on récupére son contenu en l'ouvrant
		if ( file_exists( '../'.$dossier.$tab_fich[$i][$j].'.txt') ) { $contenu = fopen( '../'.$dossier.$tab_fich[$i][$j].'.txt', 'r' ); }
		// si le fichier existe et que le statut de connexion le permet : statut de connexion sup ou égal à 1ère ligne du contenu
		if ( file_exists( '../'.$dossier.$tab_fich[$i][$j].'.txt') && $statconnex >= fgets($contenu) )
			{
			$lien = fgets($contenu); // lecture 2ème ligne du contenu
			$mefd = '<a href="'.$lien.$ciblelien.'>'; // début mise en forme du lien
			$meff = '</a>'; // fin mise en forme du lien
			
			if ($j == 6) { // cas particuliers des dimanches
				echo "<td".(($num_mois == date("n") && $num_an == date("Y") && $tab_cal[$i][$j] == date("j"))? $styledimanchejourj : $styledimanche ).">".$mefd.((strpos($tab_cal[$i][$j],"*")!==false)?'<span>'.str_replace("*","",$tab_cal[$i][$j]).'</span>':$tab_cal[$i][$j]).$meff."</td>";
				}
			else if ($tab_ferie[$i][$j] == 1) { // cas particuliers des jours fériés du mois courant
				echo "<td".(($num_mois == date("n") && $num_an == date("Y") && $tab_cal[$i][$j] == date("j"))? $styleferiejourj : $styleferie ).">".$mefd.((strpos($tab_cal[$i][$j],"*")!==false)?'<span>'.str_replace("*","",$tab_cal[$i][$j]).'</span>':$tab_cal[$i][$j]).$meff."</td>";
				}
			else { // autres jours de la semaine
				echo "<td".(($num_mois == date("n") && $num_an == date("Y") && $tab_cal[$i][$j] == date("j"))? $styleautrejourj : null ).">".$mefd.((strpos($tab_cal[$i][$j],"*")!==false)?'<span>'.str_replace("*","",$tab_cal[$i][$j]).'</span>':$tab_cal[$i][$j]).$meff."</td>";
				}
			
			} // FIN si le fichier existe et que le statut de connexion le permet : statut de connexion sup ou égal à 1ère ligne du contenu
				// le fichier n'existe pas ou le statut de connexion ne le permet pas : l'affichage est sans lien
		else if ($j == 6) { // cas particuliers des dimanches
				echo "<td".(($num_mois == date("n") && $num_an == date("Y") && $tab_cal[$i][$j] == date("j"))? $styledimanchejourj : $styledimanche ).">".((strpos($tab_cal[$i][$j],"*")!==false)? '<font'.$policedimanchemoisAVetAP.'>'.str_replace("*","",$tab_cal[$i][$j]).'</font>':$tab_cal[$i][$j])."</td>";
				}
			else if ($tab_ferie[$i][$j] == 1) { // cas particuliers des jours fériés du mois courant
				echo "<td".(($num_mois == date("n") && $num_an == date("Y") && $tab_cal[$i][$j] == date("j"))? $styleferiejourj : $styleferie ).">".((strpos($tab_cal[$i][$j],"*")!==false)? '<font'.$policejourmoisAVetAP.'>'.str_replace("*","",$tab_cal[$i][$j]).'</font>':$tab_cal[$i][$j])."</td>";
				}
			else { // autres jours de la semaine
				echo "<td".(($num_mois == date("n") && $num_an == date("Y") && $tab_cal[$i][$j] == date("j"))? $styleautrejourj : null ).">".((strpos($tab_cal[$i][$j],"*")!==false)? '<font'.$policejourmoisAVetAP.'>'.str_replace("*","",$tab_cal[$i][$j]).'</font>':$tab_cal[$i][$j])."</td>";
				}
				// FIN le fichier n'existe pas ou le statut de connexion ne le permet pas : l'affichage est sans lien
		}
		echo "</tr>";
	}
?>
</table>
</body>
</html>